import pandas as pd
import numpy as np
from scipy import stats 
import pickle

atp_tennis = pd.read_csv('atp_tennis.csv')

anova_results = {}   
for group in ['Top-ranked', 'Mid-ranked', 'Low-ranked']:   
    group_data = player_data.merge(unique_player_data[unique_player_data['Rank_Group'] == group][['Player', 'Rank_Group']], on='Player')   
    hard_data = group_data['Win_Loss_Ratio'][group_data['Surface'] == 'Hard'].dropna()   
    clay_data = group_data['Win_Loss_Ratio'][group_data['Surface'] == 'Clay'].dropna()   
    grass_data = group_data['Win_Loss_Ratio'][group_data['Surface'] == 'Grass'].dropna()   

    if len(hard_data) > 0 and len(clay_data) > 0 and len(grass_data) > 0:   
        anova_result = stats.f_oneway(hard_data, clay_data, grass_data)   
        anova_results[group] = anova_result.pvalue   

    else:   
        anova_results[group] = None 

print(anova_results)
pickle.dump(anova_results,open("./ref_result/anova_results.pkl","wb"))